#ifndef _BOARD_CONFIG_H_
#define _BOARD_CONFIG_H_

#include <driver/gpio.h>

#define AUDIO_INPUT_SAMPLE_RATE  24000
#define AUDIO_OUTPUT_SAMPLE_RATE 24000

#define AUDIO_I2S_GPIO_MCLK  GPIO_NUM_38
#define AUDIO_I2S_GPIO_WS    GPIO_NUM_41
#define AUDIO_I2S_GPIO_BCLK  GPIO_NUM_39
#define AUDIO_I2S_GPIO_DIN   GPIO_NUM_40
#define AUDIO_I2S_GPIO_DOUT  GPIO_NUM_42

#define AUDIO_CODEC_PA_PIN       GPIO_NUM_46
#define AUDIO_CODEC_I2C_SDA_PIN  GPIO_NUM_47
#define AUDIO_CODEC_I2C_SCL_PIN  GPIO_NUM_48
#define AUDIO_CODEC_ES8311_ADDR  ES8311_CODEC_DEFAULT_ADDR

#define BOOT_BUTTON_GPIO        GPIO_NUM_0
#define PWR_BUTTON_GPIO         GPIO_NUM_17
#define PWR_EN_GPIO             GPIO_NUM_18


/*disp-qspi-lcd*/
#define LCD_CS       GPIO_NUM_10
#define LCD_PCLK     GPIO_NUM_11
#define LCD_D0       GPIO_NUM_12
#define LCD_D1       GPIO_NUM_13
#define LCD_D2       GPIO_NUM_14
#define LCD_D3       GPIO_NUM_15
#define LCD_RST      GPIO_NUM_8
#define LCD_LIGHT    (-1)

#define EXAMPLE_LCD_H_RES 466
#define EXAMPLE_LCD_V_RES 466
 
#define DISPLAY_MIRROR_X false
#define DISPLAY_MIRROR_Y false
#define DISPLAY_SWAP_XY false

#define DISPLAY_OFFSET_X  0
#define DISPLAY_OFFSET_Y  0



#endif // _BOARD_CONFIG_H_
